*! version 5.0
* 13 August 2018
* NIDS
* Master ependiture do file for Nids Wave 1

* THIS IS THE MASTER EXPENDITURE DO FILE: 1 OF 14
* THESE 14 DO FILES CREATE THE NIDS WAVE 1 EXPENDITURE VARIABLES FOR PUBLIC RELEASE THAT ARE
* TO BE FOUND IN THE INDIVIDUAL AND HOUSEHOLD DERIVED DATASETS.

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

global DataIN "C:\Users\Admin\Desktop\Data" //File path to where data is located. Change this path according to where your data folder is located on your computer.
global DataOUT "C:\Users\Admin\Desktop\Data\Wave 1\Output"

global DoFilePath "C:\Users\Admin\Desktop\Data\dofiles\\Expenditure"  // file path to other expenditure do files

global VersionIN "W1_Anon_V7.0.0"
global VersionOUT "Exp"

*=====================================================================================================================================
* SETTING UP STATA TO RUN DO FILES

clear
cap clear matrix
set more off 

version 12.0

*-------------------------------------------------------------------------------------------------------------------------------------


* MERGING THE REQUIRED DATASETS: DO FILE 2 of 14
do "$DoFilePath\W1 Food_NonFood Expenditure 1 - Merging HH variables (2 of 14).do"
do "$DoFilePath\W1 Food_NonFood Expenditure 3 - Generating derived variables (3 of 14).do"

* Performs Imputations for food and non-food items, each time this is done in three steps
do "$DoFilePath\W1 Food_NonFood Expenditure 4 - Food variable preparation (4 of 14).do"
do "$DoFilePath\W1 Food_NonFood Expenditure 5 - Food item imputations (5 of 14).do"
do "$DoFilePath\W1 Food_NonFood Expenditure 6 - Food aggregate imputations (6 of 14).do"
do "$DoFilePath\W1 Food_NonFood Expenditure 7 - Non-food variable preparation (7 of 14).do"
do "$DoFilePath\W1 Food_NonFood Expenditure 8 - Non-food item imputation (8 of 14).do"
do "$DoFilePath\W1 Food_NonFood Expenditure 9 - Non-food aggregate imputation (9 of 14).do"

**Creates an DataOUT file with ALL of the expenditure variables including the derived expenditure on every line item, dummy variables
*to indicate imputation, and data for both the cell median and regression imputation techniques
do "$DoFilePath\W1 Food_NonFood Expenditure 10 - Aggregation of expenditure (10 of 14).do"

**Reduces the data set to just Four derived variables 
do "$DoFilePath\W1 Food_NonFood Expenditure 11 - Final release of expenditure data (11 of 14).do"

* end of master do file
*=====================================================================================================================================
